

import java.io.IOException;
import java.io.RandomAccessFile;

// Referenced classes of package duggelz.jape:
//            Actor, BasicStructure, JapeAlg, JapeConst, 
//            Mercenary

public class SaveGame
{
    public class FormatException extends Exception
    {

        public FormatException()
        {
        }
    }


    public SaveGame()
    {
        thingCountOffset = 815;
        thingCount = 0;
        thingOffset = 819;
        thingDataLength = 28;
        otherThingDataLength = 7440;
        actorCount = 170;
        actorDataLength = 716;
        actorOffset = 0;
        actors = new Actor[actorCount];
        mercCount = 0;
        mercMaxCount = 18;
        mercDataLength = 2462;
        mercOffset = 0;
        mercs = new Mercenary[mercMaxCount];
    }

    public int[] findActorCodeTable(byte ciphertext[])
    {
        for(int mainTable = 0; mainTable < 4; mainTable++)
        {
            for(int subTable = 0; subTable < 57; subTable++)
            {
                byte plaintext[] = JapeAlg.Decode(ciphertext, 8, JapeConst.CodeTables[mainTable][subTable]);
                if(plaintext[1] == 0 && plaintext[3] == 0 && plaintext[5] == 0 && plaintext[7] == 0)
                {
                    int results[] = {
                        mainTable, subTable
                    };
                    return results;
                }
            }

        }

        return null;
    }

    public Actor getActor(int idx)
    {
        return actors[idx];
    }

    public Actor getActorByNick(String nick)
    {
        for(int idx = 0; idx < actorCount; idx++)
        {
            Actor actor = actors[idx];
            if(actor != null && actor.get("Nickname").equals(nick))
                return actor;
        }

        return null;
    }

    public Mercenary getMerc(int idx)
    {
        return mercs[idx];
    }

    public Mercenary getMercByNick(String nick)
    {
        for(int idx = 0; idx < mercCount; idx++)
        {
            Mercenary merc = mercs[idx];
            if(merc != null && merc.get("Nickname").equals(nick))
                return merc;
        }

        return null;
    }

    public void load(String filename)
        throws IOException, FormatException
    {
        this.filename = filename;
        file = new RandomAccessFile(this.filename, "r");
        try
        {
            file.seek(thingCountOffset);
            thingCount = file.readByte() & 0xff;
            actorOffset = thingOffset + thingCount * thingDataLength + otherThingDataLength;
            mercOffset = actorOffset + actorDataLength * actorCount;
            file.seek(actorOffset);
            byte rawData[] = new byte[16];
            file.readFully(rawData);
            int indexes[] = findActorCodeTable(rawData);
            if(indexes == null)
                throw new FormatException();
            codeTableIdx = indexes[0];
            codeTableSubIdx = indexes[1];
            codeTable = JapeConst.CodeTables[codeTableIdx][codeTableSubIdx];
            loadActors();
            loadMercs();
        }
        finally
        {
            file.close();
        }
    }

    public void loadActors()
        throws IOException
    {
        file.seek(actorOffset);
        for(int idx = 0; idx < actorCount; idx++)
        {
            byte actorData[] = new byte[actorDataLength];
            file.readFully(actorData);
            Actor actor = new Actor(actorData, codeTable);
            actors[idx] = actor;
        }

    }

    public void loadMercs()
        throws IOException
    {
        file.seek(mercOffset);
        for(int mercIdx = 0; mercIdx < 18; mercIdx++)
        {
            int adjustIdx;
            for(adjustIdx = 0; adjustIdx < 16; adjustIdx++)
            {
                if(file.readByte() != 1)
                    continue;
                file.seek(file.getFilePointer() - 1L);
                break;
            }

            if(adjustIdx == 16)
                break;
            byte mercData[] = new byte[mercDataLength];
            file.readFully(mercData);
            Mercenary merc = new Mercenary(mercData, codeTable);
            mercs[mercCount] = merc;
            mercCount = mercCount + 1;
            merc.adjustCount = adjustIdx;
        }

    }

    public void save()
        throws IOException
    {
        file = new RandomAccessFile(filename, "rw");
        try
        {
            saveActors();
            saveMercs();
        }
        finally
        {
            file.close();
        }
    }

    public void saveActors()
        throws IOException
    {
        file.seek(actorOffset);
        for(int idx = 0; idx < actorCount; idx++)
        {
            Actor actor = actors[idx];
            byte actorData[] = actor.encode(codeTable);
            file.write(actorData);
        }

    }

    public void saveMercs()
        throws IOException
    {
        file.seek(mercOffset);
        for(int idx = 0; idx < mercCount; idx++)
        {
            Mercenary merc = mercs[idx];
            byte mercData[] = merc.encode(codeTable);
            for(int i = 0; i < merc.adjustCount; i++)
                file.writeByte(0);

            file.write(mercData);
        }

    }

    public int thingCountOffset;
    public int thingCount;
    public int thingOffset;
    public int thingDataLength;
    public int otherThingDataLength;
    public int actorCount;
    public int actorDataLength;
    public int actorOffset;
    public Actor actors[];
    public int mercCount;
    public int mercMaxCount;
    public int mercDataLength;
    public int mercOffset;
    public Mercenary mercs[];
    public String filename;
    public RandomAccessFile file;
    public int codeTableIdx;
    public int codeTableSubIdx;
    public int codeTable[];
}